/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.modular_accumulator;

import com.mrh0.createaddition.blocks.modular_accumulator.CAConnectivityHandler;
import com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlock;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.debug.IDebugDrawer;
import com.mrh0.createaddition.energy.IMultiTileEnergyContainer;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.sound.CASoundScapes;
import com.mrh0.createaddition.transfer.EnergyTransferable;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.Create;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.outliner.Outliner;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class ModularAccumulatorBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IMultiTileEnergyContainer,
IObserveTileEntity,
IDebugDrawer,
ThresholdSwitchObservable,
EnergyTransferable {
    protected LazyOptional<EnergyStorage> energyCap;
    protected InternalEnergyStorage energyStorage;
    protected class_2338 controller;
    protected class_2338 lastKnownPos;
    protected boolean updateConnectivity = false;
    protected int width = 1;
    protected int height = 1;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private EnergyStorage escacheUp = null;
    private EnergyStorage escacheDown = null;
    public LerpedFloat gauge = LerpedFloat.linear();
    long lastEnergy = 0L;
    boolean firstTickState = true;
    int energyChangeTick = 0;

    public ModularAccumulatorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.energyStorage = this.createEnergyStorage();
        this.energyCap = LazyOptional.of(() -> this.energyStorage);
        this.refreshCapability();
    }

    public void onChunkUnloaded() {
    }

    protected InternalEnergyStorage createEnergyStorage() {
        return new InternalEnergyStorage(ModularAccumulatorBlockEntity.getCapacityMultiplier(), (Long)Config.ACCUMULATOR_MAX_INPUT.get(), (Long)Config.ACCUMULATOR_MAX_OUTPUT.get());
    }

    public void setCache(class_2350 side, EnergyStorage storage) {
        switch (side) {
            case field_11033: {
                this.escacheDown = storage;
                break;
            }
            case field_11036: {
                this.escacheUp = storage;
            }
        }
    }

    public EnergyStorage getCachedEnergy(class_2350 side) {
        return switch (side) {
            case class_2350.field_11033 -> this.escacheDown;
            case class_2350.field_11036 -> this.escacheUp;
            default -> null;
        };
    }

    public void firstTick() {
        this.updateCache();
    }

    public void updateCache() {
        if (this.field_11863.method_8608()) {
            return;
        }
        for (class_2350 side : class_2350.values()) {
            this.updateCache(side);
        }
    }

    public void updateCache(class_2350 side) {
        if (this.method_11015()) {
            return;
        }
        if (!this.field_11863.method_8477(this.field_11867.method_10093(side))) {
            this.setCache(side, null);
            return;
        }
        EnergyStorage le = (EnergyStorage)EnergyStorage.SIDED.find(this.field_11863, this.field_11867.method_10093(side), (Object)side.method_10153());
        if (le == null) {
            this.setCache(side, null);
            return;
        }
        if (side != class_2350.field_11036 && side != class_2350.field_11033) {
            return;
        }
        if (le.equals((Object)this.getCachedEnergy(side))) {
            return;
        }
        this.setCache(side, le);
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        if (!this.field_11863.method_8477(this.method_11016())) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        CAConnectivityHandler.formMulti(this);
    }

    public void tick() {
        super.tick();
        if (this.firstTickState) {
            this.firstTick();
        }
        this.firstTickState = false;
        this.tickOutput();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.method_11016();
        } else if (!this.lastKnownPos.equals((Object)this.field_11867) && this.field_11867 != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (!this.isController()) {
            return;
        }
        if (Math.abs(this.lastEnergy - this.energyStorage.getAmount()) > 256L) {
            this.lastEnergy = this.energyStorage.getAmount();
            this.onEnergyChanged();
        }
        if (this.energyChangeTick > 0) {
            --this.energyChangeTick;
        }
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.method_8608()) {
            this.tickAudio();
            this.gauge.tickChaser();
            float current = this.gauge.getValue(1.0f);
            if (current > 1.0f && Create.RANDOM.nextFloat() < 0.5f) {
                this.gauge.setValueNoUpdate((double)(current + Math.min(-(current - 1.0f) * Create.RANDOM.nextFloat(), 0.0f)));
            }
        }
    }

    public void tickOutput() {
        if (this.getControllerBE() == null) {
            return;
        }
        class_2680 state = this.method_11010();
        if (((Boolean)state.method_11654((class_2769)ModularAccumulatorBlock.TOP)).booleanValue()) {
            this.tickOutputSide(class_2350.field_11036);
        }
        if (((Boolean)state.method_11654((class_2769)ModularAccumulatorBlock.BOTTOM)).booleanValue()) {
            this.tickOutputSide(class_2350.field_11033);
        }
    }

    public void tickOutputSide(class_2350 side) {
        EnergyStorage ies = this.getCachedEnergy(side);
        if (ies == null) {
            return;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            EnergyStorageUtil.move((EnergyStorage)this.getControllerBE().energyStorage, (EnergyStorage)ies, (long)((Long)Config.ACCUMULATOR_MAX_OUTPUT.get()), (TransactionContext)t);
            t.commit();
        }
    }

    public void tickAudio() {
        if (this.energyChangeTick == 0) {
            return;
        }
        int sizeInBlocks = this.getTotalAccumulatorSize();
        float pitch = 0.75f;
        if (sizeInBlocks < 4) {
            pitch = 1.25f;
        }
        if (sizeInBlocks < 9) {
            pitch = 1.0f;
        }
        CASoundScapes.play(CASoundScapes.AmbienceGroup.CHARGE, this.field_11867, pitch);
    }

    public class_2338 getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.field_11867.method_10263() == this.controller.method_10263() && this.field_11867.method_10264() == this.controller.method_10264() && this.field_11867.method_10260() == this.controller.method_10260();
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.field_11867;
    }

    protected void onEnergyChanged() {
        if (this.field_11863 == null) {
            return;
        }
        if (!this.field_11863.method_8477(this.method_11016())) {
            return;
        }
        if (!this.method_11002()) {
            return;
        }
        this.energyChangeTick = 20;
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    class_2338 pos = this.field_11867.method_10069(xOffset, yOffset, zOffset);
                    if (!this.field_11863.method_8477(pos)) {
                        return;
                    }
                    ModularAccumulatorBlockEntity acc = (ModularAccumulatorBlockEntity)CAConnectivityHandler.partAt(this.method_11017(), (class_1922)this.field_11863, pos);
                    if (acc == null) continue;
                    this.field_11863.method_8455(pos, acc.method_11010().method_26204());
                }
            }
        }
        if (!this.field_11863.field_9236) {
            this.method_5431();
            this.sendData();
        }
    }

    public ModularAccumulatorBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        if (this.field_11863 == null) {
            return null;
        }
        if (!this.field_11863.method_8477(this.method_11016())) {
            return null;
        }
        class_2586 tileEntity = this.field_11863.method_8321(this.controller);
        if (tileEntity instanceof ModularAccumulatorBlockEntity) {
            return (ModularAccumulatorBlockEntity)tileEntity;
        }
        return null;
    }

    public void applySize(int blocks) {
        this.energyStorage.setCapacity((long)blocks * ModularAccumulatorBlockEntity.getCapacityMultiplier());
        long overflow = this.energyStorage.getAmount() - this.energyStorage.getCapacity();
        try (Transaction t = TransferUtil.getTransaction();){
            if (overflow > 0L) {
                this.energyStorage.extract(overflow, (TransactionContext)t);
            }
            t.commit();
        }
    }

    public void removeController(boolean keepEnergy) {
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        if (!this.field_11863.method_8477(this.method_11016())) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepEnergy) {
            this.applySize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onEnergyChanged();
        class_2680 state = this.method_11010();
        if (ModularAccumulatorBlock.isAccumulator(state)) {
            state = (class_2680)state.method_11657((class_2769)ModularAccumulatorBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (class_2680)state.method_11657((class_2769)ModularAccumulatorBlock.TOP, (Comparable)Boolean.valueOf(true));
            this.method_10997().method_8652(this.field_11867, state, 22);
        }
        this.refreshCapability();
        this.method_5431();
        this.sendData();
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setController(class_2338 controller) {
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.method_5431();
        this.sendData();
    }

    private void refreshCapability() {
        LazyOptional<EnergyStorage> oldCap = this.energyCap;
        this.energyCap = LazyOptional.of(this::handlerForCapability);
        oldCap.invalidate();
    }

    private InternalEnergyStorage handlerForCapability() {
        return this.isController() ? this.energyStorage : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new InternalEnergyStorage(0L, (Long)Config.ACCUMULATOR_MAX_INPUT.get(), (Long)Config.ACCUMULATOR_MAX_OUTPUT.get()));
    }

    public class_2338 getController() {
        return this.isController() ? this.field_11867 : this.controller;
    }

    protected class_238 createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().method_1012((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        class_2338 controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        this.updateConnectivity = compound.method_10545("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.method_10545("LastKnownPos")) {
            this.lastKnownPos = class_2512.method_10691((class_2487)compound.method_10562("LastKnownPos"));
        }
        if (compound.method_10545("Controller")) {
            this.controller = class_2512.method_10691((class_2487)compound.method_10562("Controller"));
        }
        if (this.isController()) {
            this.width = compound.method_10550("Size");
            this.height = compound.method_10550("Height");
            this.energyStorage.setCapacity((long)this.getTotalAccumulatorSize() * ModularAccumulatorBlockEntity.getCapacityMultiplier());
            this.energyStorage.read(compound.method_10562("EnergyContent"));
            try (Transaction t = TransferUtil.getTransaction();){
                if (this.energyStorage.getSpace() < 0L) {
                    this.energyStorage.extract(-this.energyStorage.getSpace(), (TransactionContext)t);
                }
            }
        }
        if (!clientPacket) {
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.method_11002()) {
                this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 16);
            }
            if (this.isController()) {
                this.energyStorage.setCapacity(ModularAccumulatorBlockEntity.getCapacityMultiplier() * (long)this.getTotalAccumulatorSize());
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            this.gauge.chase((double)this.getFillState(), 0.125, LerpedFloat.Chaser.EXP);
        }
    }

    public float getFillState() {
        return (float)this.energyStorage.getAmount() / (float)this.energyStorage.getCapacity();
    }

    public void write(class_2487 compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.method_10556("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.method_10566("LastKnownPos", (class_2520)class_2512.method_10692((class_2338)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.method_10566("Controller", (class_2520)class_2512.method_10692((class_2338)this.controller));
        }
        if (this.isController()) {
            compound.method_10566("EnergyContent", (class_2520)this.energyStorage.write(new class_2487()));
            compound.method_10544("EnergyCapacity", (long)this.getTotalAccumulatorSize() * ModularAccumulatorBlockEntity.getCapacityMultiplier());
            compound.method_10569("Size", this.width);
            compound.method_10569("Height", this.height);
        }
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.queuedSync) {
            compound.method_10556("LazySync", true);
        }
    }

    @Override
    @Nonnull
    public EnergyStorage getEnergyStorage(@Nullable class_2350 side) {
        if (!this.energyCap.isPresent()) {
            this.refreshCapability();
        }
        return (EnergyStorage)this.energyCap.getValueUnsafer();
    }

    public void invalidate() {
        this.energyCap.invalidate();
        super.invalidate();
    }

    public int getTotalAccumulatorSize() {
        return this.width * this.width * this.height;
    }

    public static long getCapacityMultiplier() {
        return (Long)Config.ACCUMULATOR_CAPACITY.get();
    }

    public static int getMaxHeight() {
        return (Integer)Config.ACCUMULATOR_MAX_HEIGHT.get();
    }

    public int getMaxWidth() {
        return (Integer)Config.ACCUMULATOR_MAX_WIDTH.get();
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        class_2680 state = this.method_11010();
        if (ModularAccumulatorBlock.isAccumulator(state)) {
            state = (class_2680)state.method_11657((class_2769)ModularAccumulatorBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().method_10264() == this.method_11016().method_10264()));
            state = (class_2680)state.method_11657((class_2769)ModularAccumulatorBlock.TOP, (Comparable)Boolean.valueOf(this.getController().method_10264() + this.height - 1 == this.method_11016().method_10264()));
            if (this.field_11863 == null) {
                return;
            }
            this.field_11863.method_8652(this.method_11016(), state, 7);
        }
        this.method_5431();
    }

    public class_2350.class_2351 getMainConnectionAxis() {
        return class_2350.class_2351.field_11052;
    }

    public int getMaxLength(class_2350.class_2351 longAxis, int width) {
        if (longAxis == class_2350.class_2351.field_11052) {
            return ModularAccumulatorBlockEntity.getMaxHeight();
        }
        return this.getMaxWidth();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        ModularAccumulatorBlockEntity controllerTE = this.getControllerBE();
        if (controllerTE == null) {
            return false;
        }
        ObservePacket.send(this.field_11867, 0);
        String spacing = " ";
        tooltip.add((class_2561)class_2561.method_43470((String)spacing).method_10852((class_2561)class_2561.method_43471((String)"createaddition.tooltip.accumulator.info").method_27692(class_124.field_1068)));
        tooltip.add((class_2561)class_2561.method_43470((String)spacing).method_10852((class_2561)class_2561.method_43471((String)"createaddition.tooltip.energy.stored").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)class_2561.method_43470((String)spacing).method_10852((class_2561)class_2561.method_43470((String)" ")).method_27693(Util.format((int)EnergyNetworkPacket.clientBuff)).method_27693("fe").method_27692(class_124.field_1075));
        tooltip.add((class_2561)class_2561.method_43470((String)spacing).method_10852((class_2561)class_2561.method_43471((String)"createaddition.tooltip.energy.capacity").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)class_2561.method_43470((String)spacing).method_10852((class_2561)class_2561.method_43470((String)" ")).method_27693(Util.format((int)controllerTE.energyStorage.getCapacity())).method_27693("fe").method_27692(class_124.field_1075));
        return true;
    }

    public void observe() {
    }

    @Override
    public void onObserved(class_3222 player, ObservePacket pack) {
        ModularAccumulatorBlockEntity controllerTE = this.getControllerBE();
        if (controllerTE == null) {
            return;
        }
        EnergyNetworkPacket.send(this.field_11867, 0L, controllerTE.energyStorage.getAmount(), player);
    }

    public boolean hasAccumulator() {
        return true;
    }

    public long getSize(int accumulator) {
        return ModularAccumulatorBlockEntity.getCapacityMultiplier();
    }

    public void setSize(int accumulator, int blocks) {
        this.applySize(blocks);
    }

    public InternalEnergyStorage getEnergy() {
        return this.energyStorage;
    }

    @Override
    public void drawDebug() {
        if (this.field_11863 == null) {
            return;
        }
        ModularAccumulatorBlockEntity controller = this.getControllerBE();
        if (controller == null) {
            return;
        }
        class_265 shape = this.field_11863.method_8320(controller.method_11016()).method_26222((class_1922)this.field_11863, controller.method_11016());
        Outliner.getInstance().chaseAABB((Object)"ca_accumulator", shape.method_1107().method_996(controller.method_11016())).lineWidth(0.0625f).colored(0xFF5B5B);
    }

    public int getMaxValue() {
        return 100;
    }

    public int getMinValue() {
        return 0;
    }

    public int getCurrentValue() {
        ModularAccumulatorBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return 0;
        }
        return (int)((float)controllerBE.energyStorage.getAmount() / (float)controllerBE.energyStorage.getCapacity() * 100.0f);
    }

    public class_5250 format(int i) {
        return class_2561.method_43470((String)(i + "%"));
    }
}

